#pragma rtGlobals=1		// Use modern global access method.
menu  "SAS 2D"
		"-"
		"Azamuthal Panel", Azumuthal_Analysis_Setup()	
		submenu "Components of Azamuthal"
		 "Correct UNICAT Aniso Scans",AnisoCorrectPanel()
		 "Hermans Calculation", Hermans_Start()
		 "Tabulate Aniso Parameters",GetAnisoParameters()
		 end
		 "-"
	end
**************************************************************

if (cmpstr(ctrlName,"AzamuthalAve")==0)
		SVAR DFInt=root:Packages:SAS_Modeling:IntensityWaveName
		SVAR DFloc=root:Packages:SAS_Modeling:DataFolderName
		setdatafolder DFloc
		NVAR 	RingCenterPixel= root:Packages:SAS_Modeling:RingCenterPixel
		NVAR 	PixelHalfWidth= root:Packages:SAS_Modeling:PixelHalfWidth
		NVAR     AngHW=root:Packages:SAS_Modeling:AngHW
		NVAR     AngCent=root:Packages:SAS_Modeling:AngCent
		NVAR    HCglobal=root:Packages:SAS_Modeling:HC
		NVAR	VCglobal=root:Packages:SAS_Modeling:VC
		NVAR	Nopnts=root:Packages:SAS_Modeling:Nopnts
		Variable inside, outside
		inside=RingCenterPixel-PixelHalfWidth
		outside=RingCenterPixel+PixelHalfWidth
		LaunchAzamuth(DFInt,DFloc, inside,outside,0,360,HCglobal,VCglobal,Nopnts,1)
	endif
	
	if (cmpstr(ctrlName,"Sector")==0)
		SVAR DFInt=root:Packages:SAS_Modeling:IntensityWaveName
		SVAR DFloc=root:Packages:SAS_Modeling:DataFolderName
		setdatafolder DFloc
		DFloc=DFloc+DFint
		NVAR 	RingCenterPixel= root:Packages:SAS_Modeling:RingCenterPixel
		NVAR 	PixelHalfWidth= root:Packages:SAS_Modeling:PixelHalfWidth
		NVAR     AngHW=root:Packages:SAS_Modeling:AngHW
		NVAR     AngCent=root:Packages:SAS_Modeling:AngCent
		NVAR    HCglobal=root:Packages:SAS_Modeling:HC
		NVAR	VCglobal=root:Packages:SAS_Modeling:VC
		NVAR	Nopnts=root:Packages:SAS_Modeling:Nopnts
		NVAR	SectorMinPixel=root:Packages:SAS_Modeling:SectorMinPixel
		NVAR	SectorMaxPixel=root:Packages:SAS_Modeling:SectorMaxPixel
		variable minang=Angcent-angHW
		variable maxang=angcent+angHW
		LaunchAzamuth(DFInt,DFloc,SectorMinPixel,SectorMaxPixel,minang,maxang,HCglobal,VCglobal,Nopnts,0)
	endif
	



Function GetAnisoParameters()
		DoWindow /K parameters
		NewNotebook/F=1/N=parameters as "ParametersNotebook"
		notebook parameters margins={0,1,10000}
		string cols="Scan\tFolderName\tAz_Blank\tAz_Transmission\tAz_Orientation\tHermans\r"
		notebook parameters, text=cols
		ScanAllFolders("root:", 4,"getAnisoParams()")
		SaveNotebook/M="Save Parameters Notebook" /I/s=6 parameters as "Parameters"
	end

function/s getAnisoParams()
	string rwavename="anisoIntensityCorr"
	if(WaveExists($rwavename))
		string thestring=note($rwavename)
		string params="", cols="",DF=getdatafolder(0)
		SVAR ListOfASBParameters
		params+=(StringByKey("SCAN_N",  thestring, "="))
	//	params+="\t"+rwavename
		params+="\t"+DF
	//	params+="\t"+(StringByKey("DATE",  thestring, "="))
			params+="\t"+(StringByKey("Az_Blank",  thestring, ":"))
			params+="\t"+(StringByKey("Az_Transmission", thestring, ":"))
			params+="\t"+(StringByKey("Az_Orientation",  thestring, ":"))
			params+="\t"+(StringByKey("Hermans",  thestring, ":"))
		params+="\r"
		notebook parameters,text=params
		return params
	endif
	return "skip"
end



Function Hermans_Start()	
	string oldDf=GetDataFolder(1)
	string ListOfVariables
	string ListOfStrings
	variable i
	if (!DataFolderExists("root:Packages:SAS_Modeling"))		
		NewDataFolder/O root:Packages
		NewDataFolder/O root:Packages:SAS_Modeling
	endif
	SetDataFolder root:Packages:SAS_Modeling					
	ListOfStrings="DataFolderName"
	

	ListOfVariables="Orientation;fold;SmallMon"
	for(i=0;i<itemsInList(ListOfVariables);i+=1)	
		DWS_CreateItem("variable",StringFromList(i,ListOfVariables))
	endfor		
	for(i=0;i<itemsInList(ListOfStrings);i+=1)	
		DWS_CreateItem("string",StringFromList(i,ListOfStrings))
	endfor	
	SVAR DFloc=root:Packages:SAS_Modeling:DataFolderName
	//Dfloc="---"
	execute"HermansPanel()"
end

function AnisoCorrectPanel() : Panel
	string ListOfVariables
	string ListOfStrings
	variable i
	if (!DataFolderExists("root:Packages:SAS_Modeling"))		
		NewDataFolder/O root:Packages
		NewDataFolder/O root:Packages:SAS_Modeling
	endif
	SetDataFolder root:Packages:SAS_Modeling					
	ListOfStrings="DataFolderName;BlankFolderName"
	ListOfVariables="Transmission"
	for(i=0;i<itemsInList(ListOfVariables);i+=1)	
		DWS_CreateItem("variable",StringFromList(i,ListOfVariables))
	endfor		
	for(i=0;i<itemsInList(ListOfStrings);i+=1)	
		DWS_CreateItem("string",StringFromList(i,ListOfStrings))
	endfor	
	SVAR Blank=root:Packages:SAS_Modeling:BlankFolderName
	//Blank="---"
	SVAR Sample=root:Packages:SAS_Modeling:DataFolderName
	NVAR Transmission=root:Packages:SAS_Modeling:transmission
	
	PauseUpdate; Silent 1		// building window...
	variable Left=340, top=350
	DoWindow/K UNICAT_Azamuthal_Correct_Panel
	NewPanel /K=1 /W=(left,top,left+375, top+125)/N=UNICAT_Azamuthal_Correct_Panel as "UNICAT_Azamuthal_Correct_Panel"//(left, top, right, bottom )
	SetDrawLayer UserBack
	SetDrawEnv fname= "Times New Roman",fsize= 16,fstyle= 3,textrgb= (0,0,52224)
	DrawText 20,25,"UNICAT Azamuthal Correction"
	
//	CheckBox SmallMon,pos={8,90},size={141,14},proc=DWSP_InputPanelCheckboxProc,title="Small Monitor?"
//	CheckBox SmallMon,value= root:packages:SAS_Modeling:SmallMon
	
	PopupMenu AZ_SelectSampleFolder,pos={8,25},size={180,21},title="Aniso Sample:",proc=DWSP_PanelPopupControl,title=""
	PopupMenu AZ_SelectSampleFolder,mode=1,popvalue=Sample,value= #"\"Aniso Sample;\"+IN2G_FindFolderWithWaveTypes(\"root:Others:\", 5, \"USAXS_PD\", 1)"
	
	PopupMenu AZ_SelectBlankFolder,pos={8,50},size={180,21},title="USAXS Blank:",proc=DWSP_PanelPopupControl,title=""
	PopupMenu AZ_SelectBlankFolder,mode=1,value=GenerateList()
	//blank+IN2G_FindFolderWithWaveTypes(\"root:USAXS:\", 5, \"USAXS_PD\", 1)"

	SetVariable Transmission pos={8,80},size={130,20},title="Transmission", limits={0,1,0.1}
	SetVariable Transmission,value= Transmission//, format="%d"	
	
	Button Az_Correct,pos={160,80},size={80,20},proc=DWSP_AnisoPanelButtonProc,title="Correct"	
	Button Hermans1,pos={160,100},size={80,20},proc=DWS_InputPanelButtonProc,title="Hermans"
end

Function/s GenerateList()//generates list of blank folders for aniso correction
	SVAR Sample=root:Packages:SAS_Modeling:DataFolderName
	if (DataFolderExists(Sample))
		setdatafolder Sample
	endif
	string List1="---;",list2
	if (waveexists(AnisointensityCorr))
		string Samplenote
		wave AnisoIntensityCorr
		SampleNote=note(AnisoIntensityCorr)
		string blankfolder= StringByKey("AZ_Blank", Samplenote)
		if (stringmatch(blankfolder, "" ))
			Blankfolder="Pick Background USAXS scan"
		endif
			list1 =blankfolder+";"
	endif
	list1+= IN2G_FindFolderWithWaveTypes("root:USAXS:", 5, "USAXS_PD", 1)
	Return list1
end


macro HermansPanel() : Panel
	PauseUpdate; Silent 1		// building window...
	variable Left=640, top=350
	DoWindow/K UNICAT_Azamuthal_Panel
	NewPanel /K=1 /W=(left,top,left+275, top+125) as "UNICAT_Azamuthal_ControlPanel"//(left, top, right, bottom )
	SetDrawLayer UserBack
	SetDrawEnv fname= "Times New Roman",fsize= 22,fstyle= 3,textrgb= (0,0,52224)
	DrawText 57,25,"1-d Azamuthal Panel"
	
	CheckBox SmallMon,pos={8,90},size={141,14},proc=DWSP_InputPanelCheckboxProc,title="Small Monitor?"
	CheckBox SmallMon,value= root:packages:SAS_Modeling:SmallMon
	
	PopupMenu UNICATSelectDataFolder,pos={8,25},size={180,21},proc=DWSP_PanelPopupControl,title=""
	PopupMenu UNICATSelectDataFolder,mode=1,popvalue=root:Packages:SAS_Modeling:DataFolderName,value= #"\"---;\"+IN2G_FindFolderWithWaveTypes(\"root:\", 5, \"AnisoIntensityCorr\", 1)"
	//DWS_GenStringOfFolders(root:Packages:SAS_Modeling:UseIndra2Data, root:Packages:SAS_Modeling:UseQRSData,root:packages:SAS_Modeling:iWavesOnly)"
	//
	SetVariable UNICAT_Orientation pos={8,50},size={100,20},proc=DWSP_SetVarProc,title="Orientation", limits={-360,360,1}
	SetVariable UNICAT_Orientation value= root:Packages:SAS_Modeling:Orientation, format="%d"	
	
	CheckBox Fold,pos={8,70},size={141,14},proc=DWSP_InputPanelCheckboxProc,title="180? Fold?"
	CheckBox Fold,value= root:packages:SAS_Modeling:Fold	
	
	Button UNICATAzamuthalCalc,pos={160,48},size={80,20},proc=DWSP_AnisoPanelButtonProc,title="Calculate"	
	Button UNICATAzamuthalReset,pos={160,68},size={80,20},proc=DWSP_AnisoPanelButtonProc,title="Reset"
	Button UNICATAzamuthalkill,pos={160,88},size={80,20},proc=DWSP_AnisoPanelButtonProc,title="Kill Graphs"
	DoWindow/c UNICAT_Azamuthal_Panel
end

Function DWSP_PanelPopupControl(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum
	String popStr

	string oldDf=GetDataFolder(1)
	//setDataFolder root:Packages:GeneralPlotingTool
	NVAR iWavesonly=root:Packages:SAS_Modeling:iWavesonly
	NVAR UseQRSData=root:Packages:SAS_Modeling:UseQRSdata
	SVAR IntDf=root:Packages:SAS_Modeling:IntensityWaveName
	SVAR QDf=root:Packages:SAS_Modeling:QWaveName
	SVAR EDf=root:Packages:SAS_Modeling:ErrorWaveName
	SVAR Dtf=root:Packages:SAS_Modeling:DataFolderName

	if (cmpstr(ctrlName,"SelectDataFolder")==0)
		SVAR DFloc=root:Packages:SAS_Modeling:DataFolderName
		Dtf=popStr
		if (cmpstr(popstr,"---")==0)
			Abort "Data not selected properly"
		else
			Dtf=popStr
			if(iWavesonly)
				PopupMenu IntensityDataName  value="---;"+DWS_ListOfWaves("iWaves")
			else
				PopupMenu IntensityDataName  value="---;"+DWS_ListOfWaves("Allwaves")
			endif	
			SVAR sam= root:P:gsam
			sam=popStr
		endif		
		
	endif
	
	if (cmpstr(ctrlName,"AZ_SelectSampleFolder")==0)
		if (cmpstr(popstr,"---")==0)
			Abort "Data not selected properly"
		else
			setdatafolder popstr	
			Dtf=popStr	
			wave AnisoIntensityCorr
			if (waveexists(AnisoIntensityCorr))	
			string Samplenote
				SampleNote=note(AnisoIntensityCorr)		
				NVAR Transmission=root:Packages:SAS_Modeling:transmission
				NVAR orientation=root:Packages:SAS_Modeling:orientation
				SVAR Blank=root:Packages:SAS_Modeling:BlankFolderName
				Transmission =NumberByKey("AZ_Transmission", Samplenote)
				Orientation =NumberByKey("AZ_Orientation", Samplenote)
				Blank =StringbyKey("AZ_Blank", Samplenote)
				AnisoCorrectPanel()
			endif
		endif
	endif
	if (cmpstr(ctrlName,"AZ_SelectBlankFolder")==0)
		if (cmpstr(popstr,"---")==0)
			Abort "Data not selected properly"
		else
			SVAR Btf=root:Packages:SAS_Modeling:BlankFolderName	
			Btf=popStr
		endif	
	endif
	
	if (cmpstr(ctrlName,"UNICATSelectDataFolder")==0)
	Dtf=popstr
		if (cmpstr(popstr,"---")==0)
			Abort "Data not selected properly"
		else
			setdatafolder popstr	
			Dtf=popStr
			variable Hermansvalue
			NVAR Orientation =root:Packages:SAS_Modeling:Orientation
			wave AnisoIntensityCorr;wave sa
			SampleNote=note(AnisoIntensityCorr)	
			variable OrientationFromNote
			OrientationFromNote= NumberbyKey("AZ_orientation", Samplenote, ":")
			if (numtype(OrientationFromNote )==0)
				orientation=OrientationFromNote
			else
				Orientation =0
			endif
			
		endif
	endif
	
	if (cmpstr(ctrlName,"IntensityDataName")==0)///here
	
		IntDF=popStr
	endif
end	


function Hermans(rwvnm,xwvnm,plotit)
	string rwvnm,xwvnm;	variable plotit
	rwvnm="AnisoIntensityCorr";xwvnm="sa"
	string samplefolder
	Prompt SampleFolder, "Select  data folder for sample", popup,  IN2G_FindFolderWithWaveTypes("root:", 5, "AnisoIntensityCorr", 1)

	doprompt "Hermans Input Panel",samplefolder

setdatafolder samplefolder	
	
		duplicate/o xwave, xwave_corrected
	  
	HermansPlot(rwvnm, xwvnm)
	HermansUniaxial($rwvnm, $xwvnm,plotit)
end

Function HermansPlot(rwavenm, xwavenm)
		//FindValue/Z/v=0 Nwave
	//	If (!(V_value==-1))
		//	DoAlert 0, "Too Many Angles\rDecrease No. of Angles and Try Again"
	//	Endif
		string rwavenm,xwavenm
		wave rwave=$rwavenm
		wave xwave=$xwavenm
		
		NVAR wavelength=root:Packages:SAS_Modeling:wavelength
		NVAR SmallMon=  root:Packages:SAS_Modeling:SmallMon
		NVAR orientation =root:Packages:SAS_Modeling:orientation
		NVAR fold =root:Packages:SAS_Modeling:fold
		
		duplicate/o $xwavenm,shiftedxwave,rotatedxwave,foldedxwave,plotxwave
		SetFormula  shiftedxwave, "sa-root:Packages:SAS_Modeling:orientation"
		SetFormula rotatedxwave,"(shiftedxwave*(shiftedxwave>=0))+((360+shiftedxwave)*(shiftedxwave<0))"//rotate to eliminate -angles
		NVAR Fold=root:Packages:SAS_Modeling:Fold
		setformula foldedxwave, "(rotatedxwave * (rotatedxwave<=180))+((rotatedxwave-180)*(rotatedxwave>180))"
		if (fold==1)
			SetFormula plotxwave,"foldedxwave"
		else
			SetFormula plotxwave,"shiftedxwave"
		endif
		   //  xwave_corrected=((acos(cos(xwave)*cos(theta)))*(xwave<=pi)+(2*pi-acos(cos(xwave)*cos(theta)))*(xwave>=pi)) // ** pan add for correction of azimuthal angle
		//foldedxwave=180/pi*acos(cos(foldedxwave*pi/180)*cos(.5*atan(pixelsize*(RingCenterPixel+pmax)/(2*SDD))))   //pan add for correction of azimuthal angle
		
		//findpeak /P /M=1000/B=4 origRwave
		//FindValue /v=0/t=0.001 shiftedxwave
		//shiftedxwave=shiftedxwave+(V_value-Trunc(V_PeakLoc+0.5))*2
		//plotxwave=shiftedxwave//(foldedxwave*fold)+rotatedxwave*(!fold)
		
		variable Hermans =HermansUniaxial(rwave,foldedxwave,1)//alwasy do Hermans on folded wave
		DUPLICATE/o $rwavenm, fit_AnisoIntensityCorr
		dowindow/K AzPlot//1d plot killed
		display/K=1/W=(385+(!SmallMon==1)*100,400*(!SmallMon==1),585+(!SmallMon==1)*200,200+(SmallMon!=1)*500) rwave vs plotxwave//new 1d plot
		
		//W=(180,400*(!SmallMon==1),380+(!SmallMon==1)*100,500*(!SmallMon==1)+200)
		DoWindow/C AzPlot
		Label left "Intensity(Cts/Pixel)"
		Label bottom "Azamuthal Angle"
		//ModifyGraph manTick(bottom)={0,(60/(1+fold)),0,0},manMinor(bottom)={0,50}
		ModifyGraph lsize=2,rgb=(0,0,65535)
		ModifyGraph mode=3,marker=19
	
		ModifyGraph grid(bottom)=2
		DoWindow/f AzPlot//rename window
		//TextBox/C/N=hermans/A=MT Hstring		
	//	TextBox/C/W=Azplot/A=MC/N=hermans "f = "+num2str(hermans) + " at orientation=("+num2str(orientation)+")" 
		CurveFit/q poly (3+(!fold)*5), rwave /X=plotxwave /D
		//appendtograph fit_AnisoIntensityCorr
		ModifyGraph grid(bottom)=1,nticks(bottom)=6
		ModifyGraph mirror(left)=1;ModifyGraph fStyle=1
End


Function Azumuthal_Analysis_Setup()		
	setupAFRLglobals()	
	DoAlert 0, "Intensity = bincount\rSearch on bincount"
	execute"AzamuthalAve_ControlPanel()"
end


Window AzamuthalAve_ControlPanel() : Panel
	PauseUpdate; Silent 1		// building window...
	variable Left=25, top=325
	DoWindow/K Azamuthal_Panel
	NewPanel /K=1 /W=(left,top,left+375, top+350) as "DWS_AzamuthalAve_ControlPanel"//(left, top, right, bottom )
	SetDrawLayer UserBack
	SetDrawEnv fname= "Times New Roman",fsize= 22,fstyle= 3,textrgb= (0,0,52224)
	DrawText 57,25,"Azamuthal Average Input Panel"
	SetDrawEnv linethick= 3,linefgc= (0,0,52224)
	DrawLine 16,199,339,199
	SetDrawEnv fsize= 16,fstyle= 1
	DrawText 8,49,"Image data input:"
	variable qmask =root:P:qmask
	CheckBox Useiwaves,pos={217,30},size={141,14},proc=DWSP_InputPanelCheckboxProc,title="i Waves only? "
	CheckBox Useiwaves,value= root:packages:GeneralplottingTool:iWavesOnly
	CheckBox Maskdata, pos={120,320},proc=AFRL_CheckProc,title="Mask?",value=1
	Button ConvertMask, pos={180,320},size={80,20},proc=DWSP_AnisoPanelButtonProc,title="Convert Mask"
	//CheckBox SmallMon,pos={110,155},size={141,14},proc=DWSP_InputPanelCheckboxProc,title="Small Monitor?"
	//CheckBox SmallMon,value= root:packages:SAS_Modeling:SmallMon
	
	//	CheckBox UseQRSData,pos={217,40},size={141,14},proc=DWSP_InputPanelCheckboxProc,title="QRS waves"
	//CheckBox UseQRSData,value= root:packages:SAS_Modeling:UseQRSdata
	
	PopupMenu SelectDataFolder,pos={8,88},size={180,21},title="Select folder with data:    ",proc=DWSP_PanelPopupControl
	PopupMenu SelectDataFolder,mode=1,popvalue="---",value= #"\"---;\"+DWS_GenStringOfFolders(1)"
	
	PopupMenu IntensityDataName,pos={8,110},size={180,21},proc=DWSP_PanelPopupControl,title="Wave with Intensity data "
	PopupMenu IntensityDataName,mode=1,popvalue="---",value= #"\"---;\"+DWS_ListOfWaves(\"i*\")"
	

	
	//Button LoadData,pos={217,40},size={80,20},proc=DWSP_AnisoPanelButtonProc,title="Load Data"
//	Button PlotCenter,pos={217,63},size={80,20},proc=DWSP_AnisoPanelButtonProc,title="PlotCenter"
	Button Sector,pos={40,290},size={80,20},proc=DWSP_AnisoPanelButtonProc,title="Sector"
	Button Azamuthal,pos={200,290},size={80,20},proc=DWSP_AnisoPanelButtonProc,title="Azamuthal"//proc=DWSP_AnisoPanelButtonProc
	
//	Button PlotLog,pos={6,170},size={80,20},proc=DWSP_AnisoPanelButtonProc,title="Plot Log"
	Button Hardware pos={6,145},size={85,20},proc=DWSP_InputPanelButtonProc,title="Hardware"
	Button Plot2d pos={6,170}, size={85,20},proc=DWSP_InputPanelButtonProc,title="Plot 2d image";DelayUpdate	
	
	SetVariable RingCenterPixel pos={180,210},size={140,20},proc=DWSP_SetVarProc,title="RingCenterPixel", limits={0,inf,1}
	SetVariable RingCenterPixel value= root:Packages:SAS_Modeling:RingCenterPixel, format="%d"
	SetVariable PixelHalfWidth pos={180,230},size={140,20},proc=DWSP_SetVarProc,title="HalfWidthPixels", limits={0,inf,1}
	SetVariable PixelHalfWidth value= root:Packages:SAS_Modeling:PixelHalfWidth//, format="%d"
	
	SetVariable AngCent pos={8,210},size={140,20},proc=DWSP_SetVarProc,title="Angle Center?", limits={0,360,1}
	SetVariable AngCent value= root:Packages:SAS_Modeling:AngCent, format="%d"	
	SetVariable AngHW pos={8,230},size={140,20},proc=DWSP_SetVarProc,title="Angle Half Width?", limits={1,360,1}
	SetVariable AngHW value= root:Packages:SAS_Modeling:AngHW, format="%d"		

	SetVariable HClocal pos={217,135},size={140,20},proc=DWSP_SetVarProc,title="Global Horz Center", limits={0,inf,1}
	SetVariable HClocal value= root:Packages:SAS_Modeling:HC, format="%4.1f"	
	SetVariable VClocal pos={217,155},size={140,20},proc=DWSP_SetVarProc,title="Global Vert Center", limits={1,inf,1}
	SetVariable VClocal value= root:Packages:SAS_Modeling:VC, format="%4.1f"		
	SetVariable Nopnts pos={217,175},size={140,20},proc=DWSP_SetVarProc,title="No. of Output Bins", limits={0,inf,5}
	SetVariable Nopnts value= root:Packages:SAS_Modeling:Nopnts, format="%d"	
	
	SetVariable Orientation pos={180,250},size={140,20},title="Orientation", limits={-360,360,1}//,proc=DWSP_SetVarProc
	SetVariable Orientation value= root:Packages:SAS_Modeling:Orientation, format="%d"	
	
	CheckBox Fold,pos={200,270},size={141,14},title="180? Fold?"//proc=DWSP_InputPanelCheckboxProc
	CheckBox Fold,value= root:packages:SAS_Modeling:Fold		
	
	SetVariable SectorMinPixel pos={8,250},size={140,20},proc=DWSP_SetVarProc,title="SectorMinPixel", limits={0,inf,1}
	SetVariable SectorMinPixel value= root:Packages:SAS_Modeling:SectorMinPixel, format="%d"
	SetVariable SectorMaxPixel pos={8,270},size={140,20},proc=DWSP_SetVarProc,title="SectorMaxPixel", limits={0,inf,1}
	SetVariable SectorMaxPixel value= root:Packages:SAS_Modeling:SectorMaxPixel//, format="%d"
	DoWindow/c Azamuthal_Panel
end

Function DWSP_AnisoPanelButtonProc(ctrlName) : ButtonControl
	String ctrlName
	string cmd ; 	SVAR basename;string iwave;string rwave;string qwave
	
	if ((cmpstr(ctrlName,"UNICATAzamuthalReset")==0)||(cmpstr(ctrlName,"UNICATAzamuthalCalc")==0))
		SVAR DFloc=root:Packages:SAS_Modeling:DataFolderName
		setdatafolder DFloc
		if(cmpstr(DFloc,"---")==0)
			Abort "Data not selected properly"
		else
			if (cmpstr(ctrlName,"UNICATAzamuthalReset")==0)
				NVAR Orientation =root:Packages:SAS_Modeling:Orientation
				Orientation=0
			endif		
			wave AnisoIntensityCorr;wave sa
			HermansPlot("AnisoIntensityCorr","sa")
			variable HermansValue=HermansUniaxial(AnisoIntensityCorr,foldedxwave,1)//help
		
			NVAR Orientation =root:Packages:SAS_Modeling:Orientation
			TextBox/C/W=Azplot/A=MC/N=hermans "f = "+num2str(HermansValue) + " at orientation=("+num2str(orientation)+")"
			String SampleNote=note(AnisoIntensityCorr)		
			Samplenote= ReplaceNumberByKey("Hermans", Samplenote, HermansValue)
			Samplenote= ReplaceNumberByKey("AZ_orientation", Samplenote, Orientation)
			Note/K AnisoIntensityCorr
			Note AnisoIntensityCorr, Samplenote
		endif		
	endif
	if (cmpstr(ctrlName,"ConvertMask")==0)
	SVAR DFloc=root:Packages:SAS_Modeling:DataFolderName
		setdatafolder DFloc
		SVAR basename
		string maskwave="i"+basename
		convertIlavskyMask($maskwave)
		wave wmask=$maskwave
		killwaves/z imask
		rename wmask, imask
		SVAR maskname=root:P:maskname
		Svar maskpath=root:P:gmask
		maskpath=Dfloc
		maskname=Dfloc+"imask"
	endif
	if (cmpstr(ctrlName,"UNICATAzamuthalkill")==0)
		dowindow/k fplot
		dowindow/k azplot
		dowindow/k azplot1
			killwaves/z pixelstatus,xwave,nwave,swave,rwave,foldedxwave,rotatedxwave,rwave,rwave_correctedw_Coef,fit_rwave,W_sigma,W_ParamConfidenceInterval,fit_anisointensityCorr
			killwaves/z plotxwave,,shiftedxwave,xwave_corrected,radians,f,w_coef
	endif
	if (cmpstr(ctrlName,"az_correct")==0)
		SVAR Blank=root:Packages:SAS_Modeling:BlankFolderName
		SVAR Sample=root:Packages:SAS_Modeling:DataFolderName
		NVAR Transmission=root:Packages:SAS_Modeling:transmission
		setdatafolder Sample
		//string Samplenote
		
		
		IN2B_CorrectAnisoData(Sample,Blank,Transmission,0)	
		wave AnisoIntensityCorr,sa
		SampleNote=note(AnisoIntensityCorr)
		Samplenote= ReplaceNumberByKey("AZ_Transmission", Samplenote, Transmission)
		Samplenote= ReplaceStringByKey("AZ_Blank", Samplenote, Blank)
		Note/K AnisoIntensityCorr
		Note AnisoIntensityCorr, Samplenote
		display/K=1 AnisoIntensityCorr vs SA;DelayUpdate
		TextBox/C/N=text0/A=MC "Sample = "+ Sample  +"\rBackground = "+Blank+"\rTransmission = "+num2str(Transmission);DelayUpdate
		Label left "Intensity";DelayUpdate
		Label bottom "Angle"
	endif
	if (cmpstr(ctrlName,"LoadData")==0)
		execute "Load2dData()"
	endif
	
		
	if (cmpstr(ctrlName,"FindCenter")==0)
		SVAR DFloc=root:Packages:SAS_Modeling:DataFolderName
		setdatafolder DFloc
		wave itemp
		variable N=Dimsize(itemp, 0 )/2
	
		silent 1
		GetMarquee left,bottom
		if(v_flag==0)
			doalert 0, "Make marquee on graph an d press Find Center"
			abort
		endif
		Variable top,bottom,left,right

			top=v_top;bottom=v_bottom;left=v_left;right=v_right
	Fitto2DGaussian_AZ(left,right,bottom,top,"itemp",1000,N,N,N)
	DrawCenter_AZ()
	Endif
	
	if (cmpstr(ctrlName,"showcenter")==0)
		SVAR DFloc=root:Packages:SAS_Modeling:DataFolderName
		setdatafolder DFloc
		NVAR	HCglobal=root:Packages:SAS_Modeling:HC
		If (!NVAR_Exists(HCglobal))
			Doalert 0,"You havenot found the center yet"
			abort
		else
			dowindow/F Azamuthal
			DrawCenter_AZ()
		endif
	endif
	variable minang,maxang
	if (cmpstr(ctrlName,"Azamuthal")==0)
		SVAR DFInt=root:Packages:SAS_Modeling:IntensityWaveName
		SVAR DFloc=root:Packages:SAS_Modeling:DataFolderName
		setdatafolder DFloc
		NVAR 	RingCenterPixel= root:Packages:SAS_Modeling:RingCenterPixel
		NVAR 	PixelHalfWidth= root:Packages:SAS_Modeling:PixelHalfWidth
		NVAR     AngHW=root:Packages:SAS_Modeling:AngHW
		NVAR     AngCent=root:Packages:SAS_Modeling:AngCent
		NVAR    HCglobal=root:Packages:SAS_Modeling:HC
		NVAR	VCglobal=root:Packages:SAS_Modeling:VC
		NVAR	Nopnts=root:Packages:SAS_Modeling:Nopnts
		NVAR    qlog=root:Packages:Convert2Dto1D:qlog
		Variable inside, outside
		inside=RingCenterPixel-PixelHalfWidth
		outside=RingCenterPixel+PixelHalfWidth
		minang=Angcent-angHW
		maxang=angcent+angHW
		LaunchAzamuth(DFInt,DFloc, inside,outside,minang,maxang,HCglobal,VCglobal,Nopnts,1)
		SVAR DFLoc2=root:Packages:SAS_Modeling:DataFolderName
		setdatafolder DFLoc2
		NVAR Fold=root:Packages:SAS_Modeling:fold
		fold = 0
		execute "HermansPanel()"
	endif
	
	if (cmpstr(ctrlName,"Sector")==0)
		SVAR DFInt=root:Packages:SAS_Modeling:IntensityWaveName
		SVAR DFloc=root:Packages:SAS_Modeling:DataFolderName
		setdatafolder DFloc
		NVAR 	RingCenterPixel= root:Packages:SAS_Modeling:RingCenterPixel
		NVAR 	PixelHalfWidth= root:Packages:SAS_Modeling:PixelHalfWidth
		NVAR     AngHW=root:Packages:SAS_Modeling:AngHW
		NVAR     AngCent=root:Packages:SAS_Modeling:AngCent
		NVAR    HCglobal=root:Packages:SAS_Modeling:HC
		NVAR	VCglobal=root:Packages:SAS_Modeling:VC
		NVAR	Nopnts=root:Packages:SAS_Modeling:Nopnts
		NVAR	SectorMinPixel=root:Packages:SAS_Modeling:SectorMinPixel
		NVAR	SectorMaxPixel=root:Packages:SAS_Modeling:SectorMaxPixel
		NVAR qlog=root:Packages:Convert2Dto1D:qlog
		NVAR qmassk =root:P:qmask
		minang=Angcent-angHW
		maxang=angcent+angHW
		//Make2DImage_blind((DFloc+DFInt), qlog)
		LaunchAzamuth(DFInt,DFloc,SectorMinPixel,SectorMaxPixel,minang,maxang,HCglobal,VCglobal,Nopnts,0)
	endif
end


FUNCTION LaunchAzamuth(DataName, DataPath,  RingCenterPixel, pmax, chimin, chimax, HC, VC,nopnts,Azamuthal)
	String DataName
	String DataPath
	Variable RingCenterPixel
	Variable pmax
	Variable chimin
	Variable chimax
	Variable HC
	Variable VC
	variable Nopnts
	Variable Azamuthal//1 for azamuthal average 0 for sector
//Variables 
	Variable nrows
	Variable ncols
	
	Variable Vert=0
	Variable Hor=0
	Variable ChiPos = 0
	Variable RadPos
	Variable Vdist
	Variable Hdist
	Variable maxradial
	Variable minradial
	Variable IntensityPhi			//intensity (counts) at angle phi, radius r
	Variable ChiPos_radians		
	Variable SinPhi
	Variable CosPhiSquared
	Variable CountCols
	Variable StartCol
	Variable EndCol
	Variable CountRows
	Variable StartRow
	Variable EndRow
	Variable bin
	Variable binvalue
	Variable DoDiags
			
					
//This variable will turn on (=1) or turn off(=0) the execution of diagnostics
	 DoDiags = 1

	String savedDataFolder = GetDataFolder(1)
	Wave Matrix = $(DataPath +  DataName)
	if ( WaveExists(Matrix) == 0 )
		DoAlert 0, "Wave not found: " + DataPath +  DataName
		return 0
	else	
	wave itemp
	duplicate/o matrix, itemp
	NVAR qmask=root:P:qmask
	SVAR maskname=root:P:maskname
	wave maskwave=$maskname


	nrows=DimSize(itemp, 0)
	ncols=DimSize(itemp, 1)
	Variable chistepsize=(chimax-chimin)/NoPnts
	variable sectorbin,sectorstepsize=(pmax-RingCenterPixel)/NoPnts
	endif
//Create output waves (in root folder)	
	Make/o/n=(nopnts) rwave=0,swave=0,Nwave=0, xwave=0,rsectorwave=0, Nsectorwave=0,qsectorwave=0 // ** pan add Nsectorwave=0,qsectorwave=0
	If(DoDiags)
		Make/O /N=(nrows,ncols) PixelStatus = 1	
	EndIf	
//***Calculate maximum radial position	
	If ( pmax < 0 )
		maxradial = min(min(HC, ncols - HC),  min(VC, nrows - VC)) // ** pan exchanged ncols with nrows
		pmax = maxradial
	else
		maxradial = pmax
	endif
//set minradial, maybe some other means of deciding on a minradial but for now set to 0.
	If ( RingCenterPixel < 0 )
		minradial = 0
		RingCenterPixel = minradial
	Else
		minradial = RingCenterPixel
	Endif


	StartCol = HC - maxradial  // ** pan change VC to HC
	EndCol = HC + maxradial  // ** pan change VC to HC
	StartRow = VC - maxradial  // ** pan change HC to VC
	EndRow = VC + maxradial  // ** pan change HC to VC

	CountCols = StartCol
	CountRows = StartRow

	do	//y direction
		Vert = CountRows  //y direction on image, 2nd index on array       // ** pan change CountCols to CountRows
		do	//x direction
			Hor = CountCols  //x direction on image, 1st index on array    // ** pan change CountRows to CountCols
		Vdist = -(Vert - VC)	//col values less than VC are actually at top of image
		Hdist = Hor - HC
		RadPos=sqrt(Vdist^2 + Hdist^2)

//Radpos must be within min and max radius		
		if (RadPos <= pmax) 
			if (RadPos >= RingCenterPixel)
			
//calculate angle between center and pixel
				
				ChiPos_radians = imag(r2polar(cmplx(Hdist, Vdist)))
				ChiPos = (180/PI)*ChiPos_radians
				//if ( ChiPos < 0 ) //angles between 180 and 360  removed by DWS
					//ChiPos += 360
				//endif	
				If(Azamuthal)
					If((ChiPos <= chimax)&&(ChiPos >= chimin)	)				
							If(DoDiags)
								PixelStatus[hor][vert] = 0 //ChiPos
							EndIf
//Bin the data for data greater than 0, 0 for masked data.
							IntensityPhi = itemp(hor)(vert)
							SinPhi = sin(ChiPos_radians)
							CosPhiSquared = (cos(ChiPos_radians))^2
							bin=round((ChiPos - chimin) /chistepsize)
							If (qmask==1)
								If (maskwave(hor)(vert)==1)	
									Nwave[bin] +=1
									Rwave[bin] += IntensityPhi
								endif
							else
									Nwave[bin] +=1
									Rwave[bin] += IntensityPhi
							endif
					EndIf					
				Endif
				IF(!Azamuthal) //look here  
					//Use this for both sectors    if ((((ChiPos-180) <= chimax)&&((ChiPos-180) >= chimin))||((ChiPos <= chimax)&&(ChiPos >= chimin))||(((ChiPos+180) <= chimax)&&((ChiPos+180) >= chimin))||(((ChiPos+360) <= chimax)&&((ChiPos+360) >= chimin))||(((ChiPos-360) <= chimax)&&((ChiPos-360) >= chimin)))
					 if (((ChiPos <= chimax)&&(ChiPos >= chimin))||(((ChiPos+360) <= chimax)&&((ChiPos+360) >= chimin))||(((ChiPos-360) <= chimax)&&((ChiPos-360) >= chimin)))

			// Pan add 3 more || for input angle between 180 and 360, 0 and 360
						If(DoDiags)
							PixelStatus[hor][vert] = 0 //ChiPos
						EndIf
						IntensityPhi = itemp(hor)(vert)
						sectorbin=round ((radpos-RingCenterPixel)/ sectorstepsize)
						If (qmask==1)
							If (maskwave(hor)(vert)==1)
								rsectorwave[sectorbin]+=IntensityPhi
								Nsectorwave[sectorbin]+=1
							endif
						else
							rsectorwave[sectorbin]+=IntensityPhi
							Nsectorwave[sectorbin]+=1
						ENDIF
					endif
				endif
			endif
		endif
		
		CountCols += 1       
		while(CountCols <= EndCol)
		CountCols = StartCol
		CountRows += 1
	while (  CountRows <= EndRow )     // **pan exchange Row with Col
		xwave= (chimin + (0.5 + p) * ChiStepSize)
		rsectorwave/=Nsectorwave[p]//not clear this should be before following lines   I = <bincount>^2  vs <bincound^2>
		Rwave /= Nwave[p] 	
		//Rwave=(Rwave^2)*0.00004756242 // ** pan add for anderson data  May need to remove for wire detector.					
		//rsectorwave=rsectorwave*rsectorwave*0.00004756242  //** pan add for anderson data  or bincount bin count

		qsectorwave=RingCenterPixel+ (0.5 + p) * sectorstepsize   //  ** pan: change chistepsize to sectorstepsize = pixels/point

		itemp*=pixelstatus//puts active pixels on image plot
		
		if (qmask)
			itemp=itemp*maskwave
		endif
		
		NVAR SDD=root:P:gSDD
		NVAR wavelength=root:P:wavelengthvalue
		NVAR Pixelsize=root:P:gPixelSize
		NVAR index=root:P:rindex
		NVAR SmallMon=  root:Packages:SAS_Modeling:SmallMon
		if (Pixelsize==0||SDD==0||wavelength==0||index==0)
			GetSpecs()//_AZ(211,.32,1.54)//(SDD,PixelSize,wavelength)
		endif

		//SolidangleCorrection(qsectorwave,rsectorwave,pixelsize,SDD,wavelength,index)
		
		
		duplicate qsectorwave,theta1
		theta1=atan(PixelSize*qsectorwave/SDD)
		qsectorwave=(4*pi/wavelength)*sin(theta1/2)
		killwaves theta1
	
	
	If(azamuthal)//pan
		FindValue/Z/v=0 Nwave
		If (!(V_value==-1))
			DoAlert 0, "zero pixel count in at least 1 pixel"
		Endif
		//To scale the results wave uncomment the following line	
		//	SetScale/P x chimin + 0.5 * ChiStepSize, ChiStepSize,"", rwave
		variable theta=.5*atan(pixelsize*(RingCenterPixel+pmax)/(2*SDD))//check this	
		xwave=xwave*pi/180
		duplicate/o xwave, xwave_corrected
	       // xwave_corrected=((acos(cos(xwave)*cos(theta)))*(xwave<=pi)+(2*pi-acos(cos(xwave)*cos(theta)))*(xwave>=pi)) // ** pan add for correction of azimuthal angle
	        xwave_corrected=xwave_corrected*180/pi
		
		duplicate/o rwave,AnisoIntensityCorr//origrwave
		duplicate/o xwave_corrected,shiftedxwave,rotatedxwave,foldedxwave,plotxwave,sa
		
		SetFormula  shiftedxwave, "xwave_corrected-root:Packages:SAS_Modeling:orientation"
		SetFormula rotatedxwave,"(shiftedxwave*(shiftedxwave>=0))+((360+shiftedxwave)*(shiftedxwave<0))"//rotate to eliminate -angle
		NVAR Fold=root:Packages:SAS_Modeling:Fold
		setformula foldedxwave, "(rotatedxwave * (rotatedxwave<=180))+((rotatedxwave-180)*(rotatedxwave>180))"
		plotxwave=(foldedxwave*fold)+rotatedxwave*(!fold)
		
		//foldedxwave=180/pi*acos(cos(foldedxwave*pi/180)*cos(.5*atan(pixelsize*(RingCenterPixel+pmax)/(2*SDD))))   //pan add for correction of azimuthal angle
		//look dws removed above
		//HermansPlot("AnisoIntensityCorr", "sa")//dws added
		//variable Hermans =HermansUniaxial(rwave,foldedxwave, 1)//alwasy do Hermans on folded wave
		variable pixelmean=RingCenterPixel+(pmax-RingCenterPixel)/2
		//SVAR DFloc= root:Packages:SAS_Modeling:DataFolderName
		//Hermans_Start() 
		
		Variable q=(4*pi/wavelength)*sin(theta)//(.5*atan(pixelsize*(RingCenterPixel+pmax)/(2*SDD)))
				
		string Hstring="q = "+Num2str(q)+ " A\r" +"Ring center pixel=" + num2str(pixelmean)//+"\rHermans = "+num2str(hermans)
		dowindow/K SectorGraph//1d plot killed
		dowindow/K AzPlot1//1d plot killed
		display/K=1/W=(540,SmallMon,790,SmallMon+250) rwave vs plotxwave//new 1d plot     
		DoWindow/C AzPlot1
		Label left "Intensity";DelayUpdate
		Label bottom "Azamuthal Angle"
		ModifyGraph manTick(bottom)={0,(60/(1+fold)),0,0},manMinor(bottom)={0,50}
		ModifyGraph lsize=2,rgb=(0,0,65535)
		ModifyGraph mode=3,marker=19
		ModifyGraph grid(bottom)=2
		DoWindow/f AzPlot1//rename window
		TextBox/C/N=hermansq/A=MT Hstring
		
		NVAR Orientation=root: Packages:SAS_Modeling: Orientation  // ** Pan add this line
		//TextBox/C/W=Azplot/A=MC/N=hermans "f = "+num2str(hermans) + " at orientation=("+num2str(orientation)+")" 
		CurveFit/q poly (3+(!fold)*5), rwave /X=plotxwave /D     
	Else
		dowindow/K fplot
		DoWindow/K AzPlot
	//	qsectorwave=(4*pi/wavelength)*sin(.5*atan(qsectorwave*pixelsize/SDD)) 

		dowindow/K SectorGraph//1d plot killed
		display/W=(540,SmallMon,790,SmallMon+250)/K=1 rsectorwave vs qsectorwave
				// ModifyGraph log=1   // ** pan cancel this line for binary data      
				ModifyGraph mode=3,marker=19,log=1
		DoWindow/c SectorGraph//rename window
		Label left "Intensity";DelayUpdate
		Label bottom "q(A)"
	Endif
	Killwaves/z SSectorwave
	Nsectorwave=Rsectorwave/sqrt(Nsectorwave)
	killwaves/z pixelstatus,xwave,nwave,swave,rwave,foldedxwave,rotatedxwave,rwave,rwave_correctedw_Coef,fit_rwave,W_sigma,W_ParamConfidenceInterval,fit_anisointensityCorr
	killwaves/z plotxwave,shiftedxwave,xwave_corrected,radians,f
	rename nsectorwave,Ssectorwave
	SVAR ListOfGraphFormating=root:Packages:GeneralplottingTool:ListOfGraphFormating
	ListOfGraphFormating=ReplaceNumberByKey("ErrorBars",ListOfGraphFormating,1,"=")//(keyStr, kwListStr  [, keySepStr  [, listSepStr ]])
	DWS_AttachErrorBars()
End


Function HermansUniaxial(rwave, xwave,plotit)//test
	wave rwave
	wave xwave
	variable plotit
	
	duplicate/o xwave, radians,f,f0
	duplicate/o rwave,rtemp
	sort radians, radians,rtemp
	//NVAR SDD=root:Packages:SAS_Modeling:SDD
	//NVAR Pixelsize=root:Packages:SAS_Modeling:PixelSize
	//NVAR RingCenterPixel= root:Packages:SAS_Modeling:RingCenterPixel
	//NVAR PixelHalfWidth= root:Packages:SAS_Modeling:PixelHalfWidth
	NVAR SmallMon=  root:Packages:SAS_Modeling:SmallMon
	//radians=180/pi*acos(cos(radians*pi/180)*cos(.5*atan(pixelsize*(RingCenterPixel+PixelHalfWidth)/SDD)))    // pan add to correct the azimuthal angle
	radians=radians+.001*((1e-5)>abs(sin(radians)))
	radians=radians*pi/180
	variable min=Radians[0]
	variable max= radians[numpnts(radians)]
	
	f0=rtemp*sin(radians)
	f=((cos(radians))^2)*rtemp*sin(radians)
	variable result
	variable Af0=areaxy(radians,f0,0,pi)
	variable Af= areaxy(radians,f,0,pi)
	
	result=Af/Af0
	result= (3/2)*result-1/2
	if(plotit==1)
		radians=radians*180/pi
		dowindow/K fplot
		display/K=1/W=(180,400*(!SmallMon==1),380+(!SmallMon==1)*100,500*(!SmallMon==1)+200) f vs radians//****
		DoWindow/C fplot
		Label left "cos(Az)^2*Intensity*sin(Az)";DelayUpdate
		Label bottom "Azimuthal Angle "
		ModifyGraph manTick(bottom)={0,30,0,0},manMinor(bottom)={0,15}
		ModifyGraph nticks(bottom)=8

		ModifyGraph lsize=2,rgb(f)=(0,0,0)
		ModifyGraph mode=3,marker=19
		ModifyGraph fStyle=1
		
	endif
	killwaves/z f0,xtemp,rtemp,r,radians
	return result
end

//following confilts with Indra procedure IN2_USAXS
//Function IN2B_CorrectAnisoData(SampleFolderName,BlankFolderName,SampleTransmission,select)//dws
	//function to correct aniso data for dark currents and blank data 
	//first find the folders which user wants to correct
	//and find blank run from which we can pull the correction parameters
	string SampleFolderName
	string BlankFolderName
	variable SampleTransmission,select
	string oldDf=GetDataFolder(1)
	Prompt SampleFolderName, "Select Aniso Folder", popup, IN2G_FindFolderWithWaveTypes("root:Others:", 5, "USAXS_PD", 1)
	Prompt BlankFolderName, "Select Blank run Folder", popup, IN2G_FindFolderWithWaveTypes("root:USAXS:", 5, "USAXS_PD", 1)
	Prompt SampleTransmission, "Input USAXS sample transmission" 
	If (Select==1)//dws
		DoPrompt "Select data to corect", SampleFolderName, BlankFolderName, SampleTransmission
	endif//dws
	Wave AnisoUSAXS_PD=$(SampleFolderName+"USAXS_PD")
	Wave AnisoSeconds=$(SampleFolderName+"seconds")
	Wave AnisoAR_enc=$(SampleFolderName+"ar_enc")
	Wave AnisoMonitor=$(SampleFolderName+"I0")
	SVAR AnisoMeasPar=$(SampleFolderName+"MeasurementParameters")

	Wave BlankUSAXS_PD=$(BlankFolderName+"USAXS_PD")
	Wave BlankPD_range=$(BlankFolderName+"pd_range")
	Wave BlankSeconds=$(BlankFolderName+"MeasTime")
	Wave BlankAR_enc=$(BlankFolderName+"ar_encoder")
	Wave BlankMonitor=$(BlankFolderName+"Monitor")
	SVAR BlankMeasPar=$(BlankFolderName+"MeasurementParameters")

	Variable AnisoPD_range=NumberByKey("UPD2range", AnisoMeasPar , ":", ";") +1		//+1 due to UDP2range being zero based UPD range
	variable AnisoPDDarkCurrent=NumberByKey("UPD2bkg"+num2str(AnisoPD_range), AnisoMeasPar , ":", ";")
	variable BlankUPDVal=interp(AnisoAR_enc[0], BlankAR_enc, BlankUSAXS_PD )	//1 based UPD range
	variable BlankPD_rangeVal=floor(interp(AnisoAR_enc[0], BlankAR_enc, BlankPD_range ))	
	variable RangeDifference=BlankPD_rangeVal-AnisoPD_range
	if (RangeDifference<0)
		Abort "Ranges weird - blank range is higher than sample" 
	endif
	variable BlankPDDarkCurrent=NumberByKey("UPD2bkg"+num2str(BlankPD_rangeVal), BlankMeasPar , "=", ";")
	setDataFolder $SampleFolderName
	
	Duplicate/O AnisoUSAXS_PD, AnisoIntensityCorr, TempAnisoBlInt
	Wave AnisoIntensityCorr
	Wave TempAnisoBlInt

	AnisoIntensityCorr=AnisoUSAXS_PD - (AnisoPDDarkCurrent*AnisoSeconds	)	//this fixes the USAXS PD for dark current
	TempAnisoBlInt= (BlankUPDVal - (BlankSeconds * BlankPDDarkCurrent)) / 10^(2*RangeDifference)
	
	AnisoIntensityCorr= AnisoIntensityCorr - SampleTransmission * (TempAnisoBlInt * AnisoMonitor / BlankMonitor)

	variable  RangeDifferenceFix=AnisoPD_range-1   //Normalize to range 1
	
	AnisoIntensityCorr=10^8*AnisoIntensityCorr/10^(2*RangeDifferenceFix)            //10^8 is arbitrary scale factor

	killWaves TempAnisoBlInt
	
	setDataFolder oldDf

end

